/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import javax.websocket.CloseReason;
import javax.websocket.Decoder;
import javax.websocket.DeploymentException;
import javax.websocket.Encoder;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import org.glassfish.tyrus.core.AnnotatedEndpoint;
import org.glassfish.tyrus.core.ErrorCollector;
import org.glassfish.tyrus.core.MessageHandlerManager;
import org.glassfish.tyrus.core.PrimitivesToWrappers;
import org.glassfish.tyrus.core.l10n.LocalizationMessages;

class AnnotatedClassValidityChecker {
    private final Class<?> annotatedClass;
    private final List<Class<? extends Encoder>> encoders;
    private final ErrorCollector collector;
    private final MessageHandlerManager handlerManager;

    public AnnotatedClassValidityChecker(Class<?> annotatedClass, List<Class<? extends Encoder>> encoders, List<Class<? extends Decoder>> decoders, ErrorCollector collector) {
        this.annotatedClass = annotatedClass;
        this.encoders = encoders;
        this.collector = collector;
        this.handlerManager = new MessageHandlerManager(decoders);
    }

    public void checkOnMessageParams(Method method2, MessageHandler handler) {
        try {
            this.handlerManager.addMessageHandler(handler);
        }
        catch (IllegalStateException ise) {
            this.collector.addException(new DeploymentException(LocalizationMessages.CLASS_CHECKER_ADD_MESSAGE_HANDLER_ERROR(this.annotatedClass.getCanonicalName(), ise.getMessage()), ise.getCause()));
        }
        this.checkOnMessageReturnType(method2);
    }

    private void checkOnMessageReturnType(Method method2) {
        Class<?> returnType = method2.getReturnType();
        if (returnType != Void.TYPE && returnType != String.class && returnType != ByteBuffer.class && returnType != byte[].class && !returnType.isPrimitive() && this.checkEncoders(returnType) && !PrimitivesToWrappers.isPrimitiveWrapper(returnType)) {
            this.logDeploymentException(new DeploymentException(LocalizationMessages.CLASS_CHECKER_FORBIDDEN_RETURN_TYPE(this.annotatedClass.getName(), method2.getName())));
        }
    }

    public void checkOnOpenParams(Method method2, Map<Integer, Class<?>> params2) {
        for (Class<?> value2 : params2.values()) {
            if (value2 == EndpointConfig.class) continue;
            this.logDeploymentException(new DeploymentException(LocalizationMessages.CLASS_CHECKER_FORBIDDEN_WEB_SOCKET_OPEN_PARAM(this.annotatedClass.getName(), method2.getName(), value2)));
        }
    }

    public void checkOnCloseParams(Method method2, Map<Integer, Class<?>> params2) {
        for (Class<?> value2 : params2.values()) {
            if (value2 == CloseReason.class) continue;
            this.logDeploymentException(new DeploymentException(LocalizationMessages.CLASS_CHECKER_FORBIDDEN_WEB_SOCKET_CLOSE_PARAM(this.annotatedClass.getName(), method2.getName())));
        }
    }

    public void checkOnErrorParams(Method method2, Map<Integer, Class<?>> params2) {
        boolean throwablePresent = false;
        for (Class<?> value2 : params2.values()) {
            if (value2 != Throwable.class) {
                this.logDeploymentException(new DeploymentException(LocalizationMessages.CLASS_CHECKER_FORBIDDEN_WEB_SOCKET_ERROR_PARAM(this.annotatedClass.getName(), method2.getName(), value2)));
                continue;
            }
            if (throwablePresent) {
                this.logDeploymentException(new DeploymentException(LocalizationMessages.CLASS_CHECKER_MULTIPLE_IDENTICAL_PARAMS(this.annotatedClass.getName(), method2.getName())));
            }
            throwablePresent = true;
        }
        if (!throwablePresent) {
            this.logDeploymentException(new DeploymentException(LocalizationMessages.CLASS_CHECKER_MANDATORY_PARAM_MISSING(this.annotatedClass.getName(), method2.getName())));
        }
    }

    private String getPrefix(String methodName) {
        return String.format("Method:  %s.%s:", this.annotatedClass.getName(), methodName);
    }

    private boolean checkEncoders(Class<?> requiredType) {
        for (Class<? extends Encoder> encoderClass : this.encoders) {
            if (!AnnotatedEndpoint.getEncoderClassType(encoderClass).isAssignableFrom(requiredType)) continue;
            return false;
        }
        return true;
    }

    private void logDeploymentException(DeploymentException de) {
        this.collector.addException(de);
    }
}

